<?php declare( strict_types=1 );

namespace FernleafSystems\Wordpress\Services\Utilities\Integrations\WpHashes\Malai;

use FernleafSystems\Wordpress\Services\Utilities\Constants\Regex;

class QueryMalwareStatusSingle extends Base {

	public const API_ENDPOINT = 'status';

	public function retrieve( string $hashSha256 ) :?string {
		$status = null;
		if ( \preg_match( sprintf( '#^%s$#', Regex::HASH_SHA256 ), $hashSha256 ) ) {
			$this->getRequestVO()->hash_sha256 = $hashSha256;
			$result = $this->query();
			$status = ( \is_array( $result ) && !empty( $result[ 'status' ] ) ) ? $result[ 'status' ] : null;
		}
		return $status;
	}

	protected function getApiUrl() :string {
		return sprintf( '%s/%s', parent::getApiUrl(), $this->getRequestVO()->hash_sha256 );
	}
}