<?php declare( strict_types=1 );

namespace FernleafSystems\Wordpress\Services\Utilities\Integrations\WpHashes\Malai;

class MalwarePatterns extends Base {

	public const API_ENDPOINT = 'patterns';

	/**
	 * @return string[][]
	 */
	public function retrieve() :array {
		$result = $this->query();
		return \array_intersect_key(
			\is_array( $result ) ? $result : [],
			\array_flip( [
				'raw',
				'iraw',
				're',
				'functions',
				'keywords',
			] )
		);
	}
}