<?php declare( strict_types=1 );

namespace FernleafSystems\Wordpress\Plugin\Shield\Scans\Afs\Processing;

/**
 * Must reflect Malai Labels
 */
class MalwareStatus {

	public const STATUS_CLEAN = 'clean';
	public const STATUS_FP = 'false_positive';
	public const STATUS_MALWARE = 'malware';
	public const STATUS_UNKNOWN = 'unknown';
	public const STATUS_UNCLASSIFIED = 'unclassified';
	public const STATUS_PREDICTED_CLEAN = 'predicted_clean';
	public const STATUS_PREDICTED_FP = 'predicted_false_positive';
	public const STATUS_PREDICTED_MALWARE = 'predicted_malware';
	public const STATUS_NOISE = 'noise';

	public function nameFromStatusLabel( string $label ) :string {
		return $this->names()[ $label ] ?? $this->names()[ self::STATUS_UNKNOWN ];
	}

	public function names() :array {
		return [
			self::STATUS_UNKNOWN           => __( 'Unknown', 'wp-simple-firewall' ),
			self::STATUS_UNCLASSIFIED      => __( 'Unclassified', 'wp-simple-firewall' ),
			self::STATUS_FP                => sprintf( '%s [%s]', __( 'Clean', 'wp-simple-firewall' ), __( 'False Positive', 'wp-simple-firewall' ) ),
			self::STATUS_CLEAN             => __( 'Clean', 'wp-simple-firewall' ),
			self::STATUS_MALWARE           => __( 'Malware', 'wp-simple-firewall' ),
			self::STATUS_PREDICTED_CLEAN   => sprintf( '%s [%s]', __( 'Clean', 'wp-simple-firewall' ), __( 'Predicted', 'wp-simple-firewall' ) ),
			self::STATUS_PREDICTED_FP      => sprintf( '%s [%s]', __( 'False', 'wp-simple-firewall' ), __( 'Predicted', 'wp-simple-firewall' ) ),
			self::STATUS_PREDICTED_MALWARE => sprintf( '%s [%s]', __( 'Malware', 'wp-simple-firewall' ), __( 'Predicted', 'wp-simple-firewall' ) ),
			self::STATUS_NOISE             => __( 'Noise', 'wp-simple-firewall' ),
		];
	}
}