<?php
////////////////////////////////////////////////////////////////////////////////////////////////////
//
//		File:
//			internal.php
//		Description:
//			This file is responsible for internal functions.
//		Copyright:
//			Copyright (c) 2010 Matthew Praetzel.
//		License:
//			This software is licensed under the terms of the End User License Agreement (EULA)
//			provided with this software. In the event the EULA is not present with this software
//			or you have not read it, please visit:
//			http://www.ternstyle.us/automatic-video-posts-plugin-for-wordpress/license.html
//
////////////////////////////////////////////////////////////////////////////////////////////////////

/****************************************Commence Script*******************************************/

use ternstyle\tern_curl as tern_curl;
use ternpress\tern_option as tern_option;

/*------------------------------------------------------------------------------------------------
	For good measure
------------------------------------------------------------------------------------------------*/

defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

/*------------------------------------------------------------------------------------------------
	Internal Functions
------------------------------------------------------------------------------------------------*/

class AYVPP_internal {

	public function __construct() {
		add_action('after_plugin_row_automatic-video-posts/init.php',[$this,'check_for_updates']);
		add_filter('pre_set_site_transient_update_plugins',[$this,'filter_update'],99,1);
		add_action('load-plugins.php',function () {
			remove_action("after_plugin_row_automatic-video-posts/init.php",'wp_plugin_update_row',10,2);
		},21);
	}
	public function check_for_updates() {
		if(is_admin() and $this->has_new_version()) {
			echo '<tr class="plugin-update-tr active">';
			echo '<td colspan="4" class="plugin-update colspanchange">';
			echo '<div class="update-message notice inline notice-warning notice-alt"><p>';
			echo 'There is a new version of Automatic Video Posts available. ';
			echo '<a href="https://shop.ternstyle.us/documentation/automatic-youtube-video-posts-plugin-for-wordpress/change-log" title="Automatic Video Posts" target="_blank">View version details</a>. ';
			echo '<em>Automatic update is unavailable for this plugin.</em> ';
			echo '<a href="https://shop.ternstyle.us/my-account" title="Automatic Video Posts" target="_blank">Download Now.</a>';
			echo '</p></div></td></tr>';
		}
	}
	public function filter_update($transient) {
		if($this->has_new_version()) {
			$obj = new stdClass();
			$obj->slug = 'automatic-video-posts';
			$obj->plugin = 'automatic-video-posts/init.php';
			$obj->new_version = $this->get_version();
			$obj->url = 'https://shop.ternstyle.us/product/automatic-video-posts-plugin-for-wordpress';
			$obj->package = '';
			$transient->response['automatic-video-posts/init.php'] = $obj;
		}
	     return $transient;
	}
	private function has_new_version() {
		$this->version = $this->fetch_version();
		if(version_compare($this->get_version(),AYVPP_VERSION) > 0) {
			return true;
		}
		return false;
	}
	private function fetch_version() {
		$version = get_transient('ayvpp_latest_version');
		if($version) {
			return $version;
		}
		$m = (new tern_curl())->get(array(
			'url'			=>	'https://shop.ternstyle.us/software/version/?software=automatic-video-posts-plugin-for-wordpress',
			'options'		=>	array(
				'RETURNTRANSFER'	=>	true,
				'FOLLOWLOCATION'	=>	true,
			)
		));
		$version = json_decode($m->body);
		set_transient('ayvpp_latest_version',$version,60*60*24);
		return $version;
	}
	private function get_version() {
		if(isset($this->version->version)) {
			return implode('.',$this->version->version);
		}
		return null;
	}
	static function is_activated() {
		global $WP_ayvpp_options;
		$ayvpp_options = (new tern_option())->get('ayvpp_settings',$WP_ayvpp_options);

		if(isset($ayvpp_options['verified']) and ($ayvpp_options['verified'] === true or (int)$ayvpp_options['verified'] === 1)) {
			return true;
		}
		return false;
	}

}
new AYVPP_internal();

/****************************************Terminate Script******************************************/
?>
