<?php
////////////////////////////////////////////////////////////////////////////////////////////////////
//
//		File:
//			import.php
//		Description:
//			This file compiles the import form and performs import upon ajax request.
//		Copyright:
//			Copyright (c) 2021 Ternstyle LLC.
//		License:
//			This software is licensed under the terms of the End User License Agreement (EULA)
//			provided with this software. In the event the EULA is not present with this software
//			or you have not read it, please visit:
//			http://www.ternstyle.us/automatic-video-posts-plugin-for-wordpress/license.html
//
////////////////////////////////////////////////////////////////////////////////////////////////////

use ternplugin\TERNPLUGIN_admin as TERNPLUGIN_admin;

/****************************************Commence Script*******************************************/

/*------------------------------------------------------------------------------------------------
	For good measure
------------------------------------------------------------------------------------------------*/

defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

/*------------------------------------------------------------------------------------------------
	Import
------------------------------------------------------------------------------------------------*/

class AYVPP_import extends TERNPLUGIN_admin {

	public $page = 'ayvpp-import-videos';
	static $include = [
		'import.php',
	];

	public function __construct() {
		parent::__construct();
	}
	public function actions() {
		parent::actions();
		add_action('wp_ajax_ayvpp_is_importing',[$this,'import'],9);
		add_action('wp_ajax_ayvpp_import',[$this,'import']);
		add_action('wp_ajax_ayvpp_file',[$this,'import']);
		add_action('wp_ajax_ayvpp_status',[$this,'import']);
	}
	public function enqueue() {
		wp_enqueue_script('ayvpp-import');
	}
	public function import() {
		if(parent::save()) {
			switch($_REQUEST['action']) {

				case 'ayvpp_is_importing' :
					$i = get_option('ayvpp_importing');
					if($i and $i > time()-86400) {
						echo json_encode(array(
							'code'		=>	500
						));
					}
					else {
						echo json_encode(array(
							'code'		=>	200
						));
					}
					die();
					exit;

				case 'ayvpp_import' :
					$parse = (new AYVPP_common_cron())->import(true);
					echo json_encode($parse);
					die();
					exit;

				default :
					break;

			}
		}
	}
}
new AYVPP_import();


/****************************************Terminate Script******************************************/
?>
