<?php
////////////////////////////////////////////////////////////////////////////////////////////////////
//
//		File:
//			activate.php
//		Description:
//			This file is responsible for activating the plugin.
//		Copyright:
//			Copyright (c) 2021 Matthew Praetzel.
//		License:
//			This software is licensed under the terms of the End User License Agreement (EULA)
//			provided with this software. In the event the EULA is not present with this software
//			or you have not read it, please visit:
//			http://www.ternstyle.us/automatic-video-posts-plugin-for-wordpress/license.html
//
////////////////////////////////////////////////////////////////////////////////////////////////////

use ternstyle\tern_curl as tern_curl;
use ternplugin\TERNPLUGIN_admin as TERNPLUGIN_admin;

/****************************************Commence Script*******************************************/

/*------------------------------------------------------------------------------------------------
	For good measure
------------------------------------------------------------------------------------------------*/

defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

/*------------------------------------------------------------------------------------------------
	Internal Functions
------------------------------------------------------------------------------------------------*/

class AYVPP_activate extends TERNPLUGIN_admin {

	public $page = 'ayvpp-activate';
	static $include = [
		'activate.php',
	];

	public function __construct() {
		parent::__construct();
	}
	public function save() {
		global $ayvpp_options,$getWP;

		if(parent::save()) {
			if(!isset($_REQUEST['action'])) {
				return;
			}

			switch($_REQUEST['action']) {

				case 'tern_activate' :
					$this->activate();
					break;

				case 'tern_deactivate' :
					$this->deactivate();
					break;

				default :
					break;

			}
		}

	}
	private function activate() {
		global $getWP,$ayvpp_options;

		if(!isset($_POST['serial']) or !isset($_POST['email'])) {
			$getWP->addError(__('Please fill out all fields.','ayvpp'));
			return;
		}

		$this->send = $this->send_activate();

		if(isset($this->send->error)) {
			$getWP->addError(__($this->send->error,'ayvpp'));
			$ayvpp_options['verified'] = false;
		}
		elseif(isset($this->send->success)) {
			$getWP->addAlert(__('Great Success!','ayvpp'));
			$ayvpp_options['verified'] = true;
		}

		$ayvpp_options['email'] = $_POST['email'];
		$ayvpp_options['serial'] = $_POST['serial'];
		$ayvpp_options = $getWP->getOption('ayvpp_settings',$ayvpp_options,true);
	}
	private function send_activate() {
		global $ayvpp_options;
		$m = (new tern_curl())->post([
			'url'			=>	'https://shop.ternstyle.us/software/activate',
			'data'			=>	[
				'key'		=>	$_POST['serial'],
				'email'		=>	$_POST['email'],
				'domain'		=>	get_bloginfo('url')
			],
			'options'			=>	[
				'RETURNTRANSFER'	=>	true,
				'FOLLOWLOCATION'	=>	true,
			]
		]);
		return json_decode($m->body);
	}
	private function deactivate() {
		global $getWP,$ayvpp_options;
		$this->reset();
		$this->send = $this->send_deactivate();
		if(isset($this->send->error)) {
			$getWP->addError(__($this->send->error,'ayvpp'));
		}
		elseif(isset($this->send->success)) {
			$getWP->addAlert(__('Great Success!','ayvpp'));
			$ayvpp_options['verified'] = false;
			$ayvpp_options['email'] = '';
			$ayvpp_options['serial'] ='';
			$ayvpp_options = $getWP->getOption('ayvpp_settings',$ayvpp_options,true);
		}
	}
	private function send_deactivate() {
		global $ayvpp_options;
		$m = (new tern_curl())->post(array(
			'url'			=>	'https://shop.ternstyle.us/software/deactivate',
			'data'			=>	array(
				'key'		=>	$ayvpp_options['serial'],
				'email'		=>	$ayvpp_options['email'],
				'domain'		=>	get_bloginfo('url')
			),
			'options'		=>	array(
				'RETURNTRANSFER'	=>	true,
				'FOLLOWLOCATION'	=>	true,
			)
		));
		return json_decode($m->body);
	}
	private function reset() {
		global $wpdb;
		$videos = $wpdb->get_col("select post_id from $wpdb->postmeta where meta_key='_ayvpp_video'");
		foreach((array)$videos as $v) {
			if(!wp_delete_post($v,true)) {
				$getWP->addError(__('There was an error while deleting a video post','ayvpp').': '.get_the_title($v));
				return false;
			}
		}
	}

}
new AYVPP_activate();

/****************************************Terminate Script******************************************/
?>
